// background.js

// Ouve o evento de clique no ícone da extensão (action)
chrome.action.onClicked.addListener(async (tab) => {
    
    // Tenta capturar a aba visível
    chrome.tabs.captureVisibleTab(tab.windowId, { format: "png" }, function(screenshotUrl) {
        
        if (screenshotUrl) {
            
            // Variável para criar um nome de arquivo único
            const filename = "print-screen-" + new Date().getTime() + ".png";
            
            // Chama a API de downloads
            chrome.downloads.download({
                url: screenshotUrl,
                filename: filename,
                saveAs: true // <-- ESTE É O PARÂMETRO CHAVE!
            }, function(downloadId) {
                if (chrome.runtime.lastError) {
                    console.error("Erro no download:", chrome.runtime.lastError.message);
                } else {
                    console.log("Download iniciado com sucesso. ID:", downloadId);
                }
            });
            
        } else {
            console.error("Não foi possível tirar o print da tela.");
        }
    });
});